#pragma once
#include "Camera.h"
class FreeCamera :
	public Camera
{
public:
	FreeCamera(Vector3 origin, Vector3 pitchYawRoll, Vector3 minimum, Vector3 maximum);	//Initial position, initial pitch, yaw and roll, minimum bounds, maximum bounds
	FreeCamera(float speed, Vector3 origin, Vector3 pitchYawRoll, Vector3 minimum, Vector3 maximum);	//Speed, Initial position, initial pitch, yaw and roll, minimum bounds, maximum bounds
	~FreeCamera();

	//Overrides
	void Animate(float dt) override;
	void MoveForward(float dt) override;
	void MoveRight(float dt) override;
	void MoveUp(float dt) override;
	void RotateX(float dt) override;
	void RotateY(float dt) override;
	void RotateZ(float dt) override;
	void RotateFromMouse(float xOffset, float yOffset, float dt) override;
};

